<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * DaaS CodeIgniter Rest Controller Extension
 *
 * An extension of Phil Sturgeon's fully RESTful server implementation for CodeIgniter
 *
 * @package        	CodeIgniter
 * @subpackage    	Libraries
 * @category    	Libraries
 * @author        	         , Shawn        s
 *
 */
 
require APPPATH.'/libraries/REST_Controller.php';
 
abstract class DaaS_REST_Controller extends REST_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->request->hmac_authenticated = $this->_hmac_authenticate_request();
		$this->request->direct_api_authorized = $this->_is_direct_api_authorized();
		$this->request->admin_api_authorized = $this->_is_admin_api_authorized();
		$this->request->uri = $_SERVER['REQUEST_URI'];
	}
	/**
	 * Parse GET
	 */
	protected function _parse_get()
	{
		// Grab proper GET variables
		parse_str(parse_url($_SERVER['REQUEST_URI'], PHP_URL_QUERY), $get);

		// Merge both the URI segments and GET params
		$this->_get_args = array_merge($this->_get_args, $get);
		
		//recreate query string
		$query_str = '';
		foreach($this->_get_args as $key=>$value) { $query_str .= $key.'='.urlencode($value).'&'; }
		$query_str = rtrim($query_str, '&');
		$this->request->body = $query_str;
	}
	
	/**
	 * Parse POST
	 */
	protected function _parse_post()
	{
		$headers = getallheaders();
		if(isset($headers['X-Real-Content-Type'])) { $this->_parse_raw_post(); }
		
		$this->_post_args = $_POST;
	
		$this->request->format and $this->request->body = file_get_contents('php://input');
		$this->request->body = file_get_contents('php://input');
	}
	
	/**
	 * Parse raw POST
	 * This function should be parsing POST requests based on RFC 2388 http://tools.ietf.org/html/rfc2388
	 */
	protected function _parse_raw_post()
	{
		$headers = getallheaders();
		// read incoming data
		$input = file_get_contents('php://input');
		if(isset($headers['X-Real-Content-Type'])) { $content_type = $headers['X-Real-Content-Type']; }
		else { $content_type = $headers['Content-Type']; }
		
		// grab multipart boundary from content type header
		preg_match('/boundary=[\"]?(.*)$/', $content_type, $matches);
		$boundary = rtrim($matches[1],'"');
		
		$parts = array_slice(explode('--'.$boundary, $input), 1);
		$data = array();
		foreach ($parts as $part) {
			if ($part == "\r\n") { break; }
			$part = ltrim($part, "\r\n");
			if(strstr($part,"\r\n\r\n")){
				list($raw_headers, $body) = explode("\r\n\r\n", $part, 2);
				$body = rtrim($body, "\r\n");
				
				// Parse the headers list
				$raw_headers = explode("\r\n", $raw_headers);
				$headers = array();
				foreach ($raw_headers as $header) {
					list($name, $value) = explode(':', $header);
					$headers[strtolower($name)] = ltrim($value, ' '); 
				}
				
				// Parse the Content-Disposition to get the field name, etc.
				if (isset($headers['content-disposition'])) {
					if (isset($headers['content-type'])) {
						if(strpos(strtolower($headers['content-type']),'text/') === 0) { //normal text field
							//get name of field
							preg_match('/name="([^"]+)"/',$headers['content-disposition'],$matches);
							if(isset($matches[1])) { $name = $matches[1]; } else { break; } //if name is not set, then it is not a valid POST field
							$_POST[$name] = $body;
						}
						else { //anything else is some sort of file presumably
							//get name of field
							preg_match('/name="([^"]+)"/',$headers['content-disposition'],$matches);
							if(isset($matches[1])) { $name = $matches[1]; } else { break; } //if name is not set, then it is not a valid POST field
							//get name of file
							preg_match('/filename="([^"]+)"/',$headers['content-disposition'],$matches);
							if(isset($matches[1])) { $filename = $matches[1]; }
							//if file name isn't available, make it the same as the field name
							if(!isset($filename)) { $filename = $name; }
							$_FILES[$name]['name'] = $filename;
							$_FILES[$name]['binary'] = $body;
							if(function_exists('mb_strlen')) { $size = mb_strlen($body, '8bit'); } 
							else { $size = strlen($body); }
							$_FILES[$name]['size'] = $size;
						}
					}
					else { //default is text/plain
						//get name of field
						preg_match('/name="([^"]+)"/',$headers['content-disposition'],$matches);
						if(isset($matches[1])) { $name = $matches[1]; } else { break; } //if name is not set, then it is not a valid POST field
						$_POST[$name] = $body;
					}
				}
			}
		}
	}
	
	/* This function authenticates a request to the API. Requests to the API are authenticated using
	 * HMAC authentication. This is done by providing an authorization header containing the public key of
	 * the authenticating application, and a hash signed with the private key. The public key is used to
	 * look up the private key on our side and attempt to recreate the hash. The hash is a combination of
	 * the HTTP verb, the Date, the content MD5 (optional), the content type (optional), and the resource being requested.	 
	 */
	protected function _hmac_authenticate_request() {
		$this->load->model('applicationmodel');
		$headers = getallheaders();
		//check headers
		if(isset($headers['Authorization'])) { //if no authorization header, return false
			$auth_header = explode(' ',$headers['Authorization']);
			$key_hash = explode(':',$auth_header[1]);
			$public_key = $key_hash[0];
			$this->request->public_key = $public_key;
			$query = $this->applicationmodel->get_application_from_public($public_key);
			if ($query->num_rows == 0){ return false; }
			$query_array = $query->row_array();
			$private_key = $query_array['private_key'];
			$hmac = base64_decode($key_hash[1]);
		}
		else { return FALSE; }
		
		$date = NULL;
		if(isset($headers['Date'])){ $date = $headers['Date']; }
		else {
			if(isset($headers['X-Daas-Date'])) { //if no date header, return false
				$date = $headers['X-Daas-Date'];
			}
			else { return FALSE; }
		}
		//check that date header was within the last 15 mins
		if (!is_null($date)){
			$now = time();
			$diff = 16;
			if(FALSE === strtotime($date)){ $diff = (($now - $date)/60); }
			else { $diff = (($now - strtotime($date))/60); }
			if ($diff > 15 || $diff < -15){ return FALSE; }
		}
		else{ return FALSE; }
		
		//if no canocialized resource, return false
		if(isset($_SERVER['REQUEST_URI'])) { 
			$resource = $_SERVER['REQUEST_URI']; //TO-DO: define canocialization and add logic here
		}
		else { return FALSE; }
		
		//get content-md5 header if it exists
		if(isset($headers['Content-Md5'])) { 
			$content_md5 = base64_decode($headers['Content-Md5']);
		}
		
		//get content-type header, if it exists (it won't for GET requests)
		if(isset($headers['Content-Type'])) { 
			$content_type = $headers['Content-Type'];
			if(isset($headers['X-Real-Content-Type'])) { $content_type = $headers['X-Real-Content-Type']; }
			if (strpos($content_type, ";") > 0){
				$content_type = substr($content_type, 0, strpos($content_type, ";"));
			}
		}
		else {
			//if no content type on a POST request, return false
			if(strtoupper($this->request->method) === 'POST') { return FALSE; }
		}
		
		//construct signed string hash
		$hash_content = strtoupper($this->request->method) . "\n";
		if(isset($date)) { $hash_content .= $date . "\n"; }
		if(isset($content_md5)) { 
			if($content_md5 !==  md5($this->request->body)) { return FALSE; } //if content-md5 provided in header doesn't match, return false
			$hash_content .= md5($this->request->body) . "\n"; 
		}
		if(isset($content_type)) { $hash_content .= $content_type. "\n"; }
		if(isset($resource)) { $hash_content .= $resource; }
		
		//PHP uses hex hmac hash by default, but other languages often use the raw binary, we will allow either
		$hmac_check_raw = hash_hmac('sha256', $hash_content, $private_key, TRUE);
		$hmac_check_hex = hash_hmac('sha256', $hash_content, $private_key, FALSE);
		return (($hmac === $hmac_check_hex) || ($hmac === $hmac_check_raw));
	}
	
	protected function _is_direct_api_authorized() {
		$this->load->library('permissions');
		$this->load->model('applicationmodel');
		if(isset($this->request->public_key)) { $public_key = $this->request->public_key; }
		if(isset($public_key)) {
			$query = $this->applicationmodel->get_application_from_public($public_key);
			if($query && $query->num_rows() === 1) {
				$result = $query->row_array(1);
				$auth = $this->permissions->get_api_authorization($result['id']);
				return $auth['direct'];
			}
		}
		return FALSE;
	}
	
	protected function _is_admin_api_authorized() {
		$this->load->library('permissions');
		$this->load->model('applicationmodel');
		if(isset($this->request->public_key)) { $public_key = $this->request->public_key; }
			if(isset($public_key)) {
			$query = $this->applicationmodel->get_application_from_public($public_key);
			if($query && $query->num_rows() === 1) {
				$result = $query->row_array(1);
				$auth = $this->permissions->get_api_authorization($result['id']);
				return $auth['admin'];
			}
		}
		return FALSE;
	}
	
	protected function create_request($call){
		$this->load->model('requestmodel');
		$app_id = null;
		$date = time();
		$this->get_header_information($app_id);
		$request_id = $this->requestmodel->create_request($app_id, $call, $date, null, null);
		return $request_id;
	}
	
	protected function get_app_id_from_header(&$app_id)
	{
		$this->load->model('applicationmodel');
		$headers = getallheaders();
		//check headers
		if(isset($headers['Authorization'])) { //if no authorization header, return false
			$auth_header = explode(' ',$headers['Authorization']);
			$key_hash = explode(':',$auth_header[1]);
			$public_key = $key_hash[0];
			$query = $this->applicationmodel->get_application_from_public($public_key);
			if ($query->num_rows == 0){ return false; }
			$query_array = $query->row_array();
			$app_id = $query_array['id'];
		}
	}
	
	protected function get_header_information(&$app_id)
	{
		$this->load->model('applicationmodel');
		$headers = getallheaders();
		//check headers
		if(isset($headers['Authorization'])) { //if no authorization header, return false
			$auth_header = explode(' ',$headers['Authorization']);
			$key_hash = explode(':',$auth_header[1]);
			$public_key = $key_hash[0];
			$query = $this->applicationmodel->get_application_from_public($public_key);
			if ($query->num_rows == 0){ return false; }
			$query_array = $query->row_array();
			$app_id = $query_array['id'];
		}
	}
	
	protected function generate_required_fields_message($fields) {
		$message = '';
		//create message with the correct tenses based on how many items in array 
		for($i = 0; $i < count($fields); $i++) {
			if($i > 0 && ($i + 1) == count($fields)) { $message .= ' and '; }
			elseif($i > 0) { $message .= ', '; }
			$message .= "'".ucfirst($fields[$i])."'";
		}
		if(count($fields) > 1){ $message .= ' are required fields';}
		else { $message .= ' is a required field.'; }
		return $message;
	}
	
	
	protected function generate_invalid_recipients_message($invalid_addresses) {
		$address_message = '';
		for($i = 0; $i < count($invalid_addresses); $i++) {
			if($i > 0 && $i < (count($invalid_addresses)-1)) { $address_message .= ', '; }
			elseif($i == (count($invalid_addresses)-1) && $i > 0) { $address_message .= ' and '; }
			$address_message .= $invalid_addresses[$i];
		}
		if (count($invalid_addresses) > 1) { $address_message .= ' are not trusted recipients.'; }
		else { $address_message .= ' is not a trusted recipient.'; }
		return $address_message;
	}
}